using System;
using Server;
using Server.Items;

namespace Server.Mobiles 
{ 
	[CorpseName( "a Old corpse" )] 
	public class FallenGod : BaseCreature 
	{ 		
		[Constructable] 
		public FallenGod() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 ) 
		{ 			
			Name = "FallenGod";
			Hue = 0;
                        Body = 256;			

			SetStr( 700, 625 );
			SetDex( 300, 176 );
			SetInt( 102, 106 );
			
			SetHits( 35000, 3189 );
			SetStam( 163, 176 );
			SetMana( 102, 106 );

			SetDamage( 35, 29 );

			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 50, 53 );
			SetResistance( ResistanceType.Fire, 45, 47 );
			SetResistance( ResistanceType.Cold, 56, 57 );
			SetResistance( ResistanceType.Poison, 50, 60 );
			SetResistance( ResistanceType.Energy, 41, 54 );

			SetSkill( SkillName.Wrestling, 122.7, 130.5 );	
			SetSkill( SkillName.Tactics, 109.3, 118.5 );
			SetSkill( SkillName.MagicResist, 72.9, 87.6 );
			SetSkill( SkillName.Anatomy, 110.5, 124.0 );
			SetSkill( SkillName.Healing, 93.6, 99.6 );
			
			if ( Paragon.ChestChance > Utility.RandomDouble() )
				PackItem( new ParagonChest( Name, TreasureMapLevel ) );
		}

		public FallenGod( Serial serial ) : base( serial )
		{
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.AosUltraRich, 5 );
		}
		
                public override void OnDeath( Container c )
		{
			base.OnDeath( c );	

				c.DropItem( new CoatOfOldGods() );
                                c.DropItem( new FurBootsOfOldGods() );
                                c.DropItem( new StatuetteOfFallenGod() );
                }

                public override WeaponAbility GetWeaponAbility()
		{
			return WeaponAbility.CrushingBlow;
		}
		
		public override int TreasureMapLevel{ get{ return 4; } }

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
	}
}